
//sValidation=nyfjs
//sCaption=Import MSWord outline ...
//sHint=Import MSWord outline items and text content
//sCategory=MainMenu.Capture
//sLocaleID=p.ImportMSWordOutline
//sAppVerMin=6.0
//sShortcutKey=

var _lc=function(sTag, sDef){return plugin.getLocaleMsg(sTag, sDef);};
var _lc2=function(sTag, sDef){return _lc(plugin.getLocaleID()+'.'+sTag, sDef);};

try{
	var xNyf=new CNyfDb(-1);

	if(xNyf.isOpen()){

		if(!xNyf.isReadonly()){

			var sSrcFn=platform.getOpenFileName(
				{ sTitle: ''
				, sFilter: 'MSWord documents (*.doc;*.docx)|*.doc;*.docx|All files (*.*)|*.*'
				, bMultiSelect: false
				, bHideReadonly: true
				});

			if(sSrcFn){

				var _find_unique_id=function(sSsgPath){
					return xNyf.getChildEntry(sSsgPath, 0);
				};

				var xMsw=new CAppWord();
				if(xMsw){

					xMsw.setVisible(false);
					var xDocs=xMsw.getDocuments();

					plugin.initProgressRange(plugin.getScriptTitle());

					var sCurItem=plugin.getCurInfoItem(-1) || plugin.getDefRootContainer();

					var xTmpFn=new CLocalFile(platform.getTempFile('', '', '.rtf')); platform.deferDeleteFile(xTmpFn);

					var _commit_infoitem=function(sSsgPath, sTitle, xDoc){
						var sPathSub='';
						var xChild=new CLocalFile(sSsgPath); xChild.append(_find_unique_id(sSsgPath));
						if(xNyf.createFolder(xChild)){
							xNyf.setFolderHint(xChild, sTitle);
							sPathSub=xChild.toString();
							if(xDoc){
								var xSsgFn=new CLocalFile(xChild); xSsgFn.append(plugin.getDefNoteFn());
								xDoc.saveAs(xTmpFn, 6); xDoc.close();
								var nBytes=xNyf.createFile(xSsgFn, xTmpFn);
								if(nBytes<0){
									sPathSub='';
									if(!confirm('Problems importing content of outline item: '+sTitle)){
										throw ('Failed to import content of the outline item: '+sTitle);
									}
								}
							}
						}
						return sPathSub;
					};

					var xDoc0=xDocs.open(sSrcFn, true);
					if(xDoc0){
						//2014.1.8 xParagraph.getOutlineLevel() throws exception (#-2147352567) with documents created by xDocs.open(FN);
						//Workaround: forcedly transfer contents into another document created with xDocs.add('');
						var xDoc1=xDocs.add('');
						var xRng0=xDoc0.getRange(0, 0); xRng0.setEnd(0x7fffFFFF); xRng0.copy();
						var xRng1=xDoc1.getRange(0, 0); xRng1.paste(); xRng1.setEnd(0x7fffFFFF);
						xDoc0.close(false);
						var xParagraphs=xRng1.getParagraphs();
						var c=xParagraphs.getCount();
						var sSsgPath=sCurItem, iLevelPrev=-1, sTitle='', xDoc2=undefined, xRng2=undefined, nDone=0;
						for(var j=0; j<c; ++j){
							var xParagraph=xParagraphs.getItem(j+1);
							if(xParagraph){
								var xRng=xParagraph.getRange();
								if(xRng){
									var iLevel=xParagraph.getOutlineLevel();
									if(iLevel>=1 && iLevel<10){

										var sPathSub=sSsgPath;
										var sTxt=xRng.getText();

										var bContinue=plugin.ctrlProgressBar(sTxt, 1, true);
										if(!bContinue) break;

										//commit the cached content;
										if(sTitle || xDoc2){
											sPathSub=_commit_infoitem(sSsgPath, sTitle, xDoc2);
											nDone++;
										}

										//then clear the data cache;
										xDoc2=undefined;
										xRng2=undefined;
										sTitle=sTxt;

										//determine ssg path of info item by level;
										if(iLevel>iLevelPrev){
											sSsgPath=sPathSub;
										}else if(iLevel<iLevelPrev){
											var iLvl=iLevel;
											while(iLvl++<iLevelPrev){
												sSsgPath=new CLocalFile(sSsgPath).getParent();
											}
										}

										iLevelPrev=iLevel;

									}else if(iLevel>=10){
										if(!xDoc2){
											xDoc2=xDocs.add('');
											xRng2=xDoc2.getRange(0, 0);
										}
										xRng.copy();
										xRng2.collapse(); //getStart(xRng2.setEnd());
										xRng2.paste();
									}
								}
							}
						}

						if(sTitle || xDoc2){
							_commit_infoitem(sSsgPath, sTitle, xDoc2);
							nDone++;
						}

						plugin.refreshOutline(-1, sCurItem);
					}

					xMsw.quit();

					var sMsg=_lc2('Done', 'Total [ %nCount% ] outline items successfully imported.').replace(/%nCount%/ig, nDone);
					alert(sMsg);

				}else{
					alert(_lc('p.Common.Fail.LoadMSWord', 'Failed to invoke Microsoft Word.'));
				}
			}

		}else{
			alert(_lc('Prompt.Warn.ReadonlyDb', 'Cannot modify the database opened as Readonly.'));
		}

	}else{
		alert(_lc('Prompt.Warn.NoDbOpened', 'No database is currently opened.'));
	}
}catch(e){
	alert(e);
}
